using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MouseLook : MonoBehaviour
{
    GameObject soupEmpty;
    public float mouseSensitivity = 150;
    bool activatePause = false;

    public bool isPaused = false;

    public GameObject pauseMenu;
    GameObject optionsMenu;
    Camera cam;
    public string focusName = "";
    internal float timescale = 1;
    public Material Outline;
    // Start is called before the first frame update
    void Start()
    {
        Outline.SetInt("Posterize", 1);
        soupEmpty = GameObject.Find("SoupEmpty");
        Cursor.lockState = CursorLockMode.Locked;
        Cursor.visible = false;
        Debug.Log("Locked Cursor");
        optionsMenu = GameObject.Find("OptionsMenu");
        cam = Camera.main;
    }

    // Update is called once per frame
    void Update()
    {
        float mouseX = Input.GetAxis("Mouse X") * mouseSensitivity * Time.deltaTime;
        soupEmpty.transform.Rotate(Vector3.up * mouseX);

        if (Input.GetKeyDown(KeyCode.Escape) || activatePause == true)
        {
            GameObject DevConsole = GameObject.Find("DevconsoleEmpty");
            if (activatePause == false)
            {
                isPaused = !isPaused;
            }
            if (isPaused)
            {
                triggerOptionMenu TOM = GameObject.Find("OptionsMenu").GetComponent<triggerOptionMenu>();
                TOM.visible = false;
                TOM.isPaused = true;
                Time.timeScale = 0f;
                optionsMenu.transform.localScale = new Vector3(0, 0, 0);
                pauseMenu.transform.localScale = new Vector3((float)2.1249, (float)2.1249, (float)2.1249);


                Cursor.visible = true;
                Cursor.lockState = CursorLockMode.None;
            }
            else
            {
                triggerOptionMenu TOM = GameObject.Find("OptionsMenu").GetComponent<triggerOptionMenu>();
                TOM.visible = false;
                TOM.isPaused = false;
                DevConsole.transform.localScale = new Vector3(0, 0, 0);
                Time.timeScale = timescale;
                Cursor.visible = false;
                Cursor.lockState = CursorLockMode.Locked;
                Debug.Log($"unpaused {timescale}");
                activatePause = false;
            }
            activatePause = false;
        }
        if (Input.GetKeyDown(KeyCode.E))
        {
            Ray ray = cam.ScreenPointToRay(Input.mousePosition);
            RaycastHit hit;

            if (Physics.Raycast(ray, out hit, 20, ~LayerMask.GetMask("Character")))
            {
                if (hit.collider.gameObject.tag != "Person")
                {
                    focusName = hit.collider.gameObject.name;
                }
            }
            Debug.Log(focusName);
        }
        if (Input.GetKeyDown(KeyCode.BackQuote))
        {
            GameObject DevConsole = GameObject.Find("DevconsoleEmpty");
            DevConsoleScript DevConsoleScriptL = DevConsole.GetComponent<DevConsoleScript>();
            DevConsoleScriptL.isVisible = !DevConsoleScriptL.isVisible;
            isPaused = true;
            activatePause = true;


        }
    }
}
